<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag\Follow;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagFollowTable;

final class HashtagFollowBuilder implements InterfaceHashtagFollowSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitHashtagFollowSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            HashtagFollowTable::FOLLOWED_HASHTAG_ID => '',
            HashtagFollowTable::FOLLOWED_BY_USER_ID => '',
            HashtagFollowTable::STAMP_REGISTRATION  => System::isoDateTime(),
            HashtagFollowTable::STAMP_LAST_UPDATE   => System::isoDateTime(),
        );
    }

    public function dispense(): HashtagFollowModel
    {
        return HashtagFollowModel::createFromData(
            array(
                // followed hashtag id

                HashtagFollowTable::FOLLOWED_HASHTAG_ID => $this -> followedHashtagId

                ?? $this -> defaultValues[HashtagFollowTable::FOLLOWED_HASHTAG_ID],

                // followed by user id

                HashtagFollowTable::FOLLOWED_BY_USER_ID => $this -> followedByUserId

                ?? $this -> defaultValues[HashtagFollowTable::FOLLOWED_BY_USER_ID],

                // stamp registration

                HashtagFollowTable::STAMP_REGISTRATION  => $this -> stampRegistration

                ?? $this -> defaultValues[HashtagFollowTable::STAMP_REGISTRATION],

                // stamp last update

                HashtagFollowTable::STAMP_LAST_UPDATE   => $this -> stampLastUpdate

                ?? $this -> defaultValues[HashtagFollowTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
